package gov.va.med.mhv.admin.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.mhv.admin.model.EmployeeOrgRoleHistory;

@Repository
public interface EmployeeOrgRoleHistoryRepository extends JpaRepository<EmployeeOrgRoleHistory, Long> {

	@Query("select empOrgRoleHistory from EmployeeOrgRoleHistory as empOrgRoleHistory"
			+ " where empOrgRoleHistory.employeeOrgRole.employee.id = :employeeId"
			+ " order by empOrgRoleHistory.modificationDate desc,"
			+ " empOrgRoleHistory.employeeOrgRole.organization.typeOfOrganization asc,"
			+ " empOrgRoleHistory.employeeOrgRole.role.name asc")
	public List<EmployeeOrgRoleHistory> getRoleHistoriesForEmployee(@Param("employeeId") Long employeeId);

}
